package gov.va.med.mhv.admin.converter;

import gov.va.med.mhv.admin.dto.EmployeeDTO;
import gov.va.med.mhv.admin.dto.EmployeeOrgRoleDTO;
import gov.va.med.mhv.admin.model.EmployeeOrgRole;

import java.util.ArrayList;
import java.util.List;

import org.springframework.stereotype.Component;
@Component
public class EmployeeOrgRoleConverter {
	
    public static EmployeeOrgRoleDTO convert(EmployeeOrgRole orgRole){
    	
    	EmployeeOrgRoleDTO employeeOrgRoleDTO = new EmployeeOrgRoleDTO();
    	employeeOrgRoleDTO.setActive(orgRole.getActive());
    	if(orgRole.getEmployee() != null) {
	    	EmployeeDTO emp = new EmployeeDTO();
	    	emp.setFirstName(orgRole.getEmployee().getFirstName());
	    	emp.setLastName(orgRole.getEmployee().getLastName());
	    	emp.setEmployeeId(orgRole.getEmployee().getId());
	    	emp.setUserName(orgRole.getEmployee().getUserName());
	    	emp.setComments(orgRole.getEmployee().getComments());
	    	employeeOrgRoleDTO.setEmployee(emp);
    	}
    	
    	employeeOrgRoleDTO.setOplock(orgRole.getOplock());
    	employeeOrgRoleDTO.setOrganization(OrgConverter.convert(orgRole.getOrganization()));
    	employeeOrgRoleDTO.setOrgRoleId(orgRole.getId());
    	employeeOrgRoleDTO.setRole(RoleConverter.convert(orgRole.getRole()));
		return employeeOrgRoleDTO;
	}
	
		public List<EmployeeOrgRoleDTO> convert(List<EmployeeOrgRole> source) {
    	
    	List<EmployeeOrgRoleDTO> destination = new ArrayList<EmployeeOrgRoleDTO>();
    	for(EmployeeOrgRole a : source) {
			destination.add(convert(a));
		}
		return destination;
	}
		
	    
	    public static EmployeeOrgRole convert(EmployeeOrgRoleDTO orgRole){
	    	
	    	EmployeeOrgRole employeeOrgRole = new EmployeeOrgRole();
	    	employeeOrgRole.setActive(orgRole.getActive());
	    	//employeeOrgRoleDTO.setEmployee(EmployeeConverter.convertEmployeeDomain(orgRole.getEmployee()));
	    	//employeeOrgRoleDTO.setEmployee(EmployeeConverter.convertEmployeeDomain(orgRole.getEmployee()));
	    	employeeOrgRole.setOplock(orgRole.getOplock());
	    	employeeOrgRole.setOrganization(OrgConverter.convert(orgRole.getOrganization()));
	    	employeeOrgRole.setRole(RoleConverter.convert(orgRole.getRole()));
			return employeeOrgRole;
		}

}
